/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationErrorIds;
import com.ibm.hwmca.fw.ntfy.DescriptiveObject;
import com.ibm.hwmca.fw.ntfy.FilterList;
import com.ibm.hwmca.fw.ntfy.NotificationService;
import com.ibm.hwmca.fw.ntfy.eventchain.ChainLink;
import com.ibm.hwmca.fw.ntfy.eventchain.Linkable;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;

public class AbstractSource
extends DescriptiveObject
implements Serializable,
Linkable,
NotificationErrorIds {
    static final long serialVersionUID = -3125831259769092579L;
    private static final String TRACE_MASKT = "XNTYASOT";
    private static final String TRACE_MASKF = "XNTYASOF";
    private static final String TRACE_MASKD = "XNTYASOD";
    private ArrayList _listeners;
    private FilterList _filters;

    public AbstractSource() {
    }

    public AbstractSource(String name, String description, FilterList filters) {
        super(name, description);
        Trace.trace(TRACE_MASKT, "-> AbstractSource()");
        this._listeners = new ArrayList();
        this._filters = filters;
        Trace.trace(TRACE_MASKT, "<- AbstractSource");
    }

    public FilterList getFilters() {
        return this._filters;
    }

    public boolean pass(EventObject event) {
        return super.pass(event) && this.getFilters().pass(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(Linkable link) {
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            this._listeners.add(link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(Linkable link) {
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            this._listeners.remove(link);
        }
    }

    public void eventReceived(EventObject event) {
    }

    public void delete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(EventObject event) {
        Trace.trace(TRACE_MASKT, "-> fireEvent(" + event + ")");
        if (this.isEnabled()) {
            ArrayList arrayList = this._listeners;
            synchronized (arrayList) {
                Trace.trace(TRACE_MASKF, "fireEvent:  listener count is " + this._listeners.size());
                Iterator i = ((ArrayList)this._listeners.clone()).iterator();
                ChainLink link = null;
                while (i.hasNext()) {
                    link = (ChainLink)i.next();
                    link.eventReceived(event);
                    Trace.trace(TRACE_MASKF, "fireEvent:  sent event to " + link);
                }
            }
        }
    }

    public boolean isEnabled() {
        boolean active = NotificationService.getManager().isEnabled() && this.isClassEnabled() && super.isEnabled();
        Trace.trace(TRACE_MASKF, "isActive:  " + active);
        return active;
    }

    private boolean isClassEnabled() {
        boolean enabled = NotificationService.getManager().getSourceClassProperties(this.getClass().getName()).isEnabled();
        Trace.trace(TRACE_MASKF, "isClassEnabled:  " + enabled);
        return enabled;
    }

    public ChainLink getChainLink() {
        ChainLink result = super.getChainLink();
        this.addEventListener(result);
        return result;
    }
}

